<?php

header('Content-Type: application/json; charset=utf-8');

include("../rs.php");

$em = trim($_POST['email'] ?? '');
$pw = trim($_POST['password'] ?? '');
$did = trim($_POST['did'] ?? '');




if (empty($em) || empty($pw) || empty($did)) {
    http_response_code(400);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}


$stmt = $conn->prepare("SELECT 1 FROM users WHERE email = ? AND password = ? AND device_id = ? AND `status` = 'Unban'");
$stmt->bind_param("sss", $em, $pw, $did);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    $stmt->close();
    $conn->close();
    exit();
}
$stmt->close();

$stmt2 = $conn->prepare("SELECT name, winning FROM users ORDER BY CAST(winning AS UNSIGNED) DESC LIMIT 20");
$stmt2->execute();
$result2 = $stmt2->get_result();

$top_users = [];
while ($row = $result2->fetch_assoc()) {
    $top_users[] = $row;
}

$stmt2->close();
$conn->close();

echo json_encode($top_users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

?>
