<?php
header('Content-Type: application/json; charset=UTF-8');
date_default_timezone_set('Asia/Dhaka');

include ("../rs.php");

$logFile   = 'ip_log.json';
$ipAddress = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$currentTime = time();

$ipLog = file_exists($logFile) ? json_decode(file_get_contents($logFile), true) : [];

if (isset($ipLog[$ipAddress]) && ($currentTime - $ipLog[$ipAddress]) < 3600) {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);
    exit;
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $name       = $_POST["name"] ?? '';
    $email      = $_POST["email"] ?? '';
    $number     = $_POST["number"] ?? '';
    $password   = $_POST["password"] ?? '';
    $device_id  = $_POST["device_id"] ?? '';
    $fcm_key    = $_POST["fcm_key"] ?? '';
    $refer_code = $_POST["refer_code"] ?? '';
    $date       = date("d/m/Y h:i a");
    $rs_refer   = rand(111111, 999999);

    $stmt = $conn->prepare("SELECT 1 FROM users WHERE device_id=?");
    $stmt->bind_param("s", $device_id);
    $stmt->execute(); $stmt->store_result();
    if ($stmt->num_rows > 0) {
        echo json_encode(["status" => "error", "message" => "Device Is Already Registered"], JSON_PRETTY_PRINT);
        exit;
    }
    $stmt->close();

    $stmt = $conn->prepare("SELECT 1 FROM users WHERE email=?");
    $stmt->bind_param("s", $email);
    $stmt->execute(); $stmt->store_result();
    if ($stmt->num_rows > 0) {
        echo json_encode(["status" => "error", "message" => "Email Is Already Registered"], JSON_PRETTY_PRINT);
        exit;
    }
    $stmt->close();

    $stmt = $conn->prepare("SELECT 1 FROM users WHERE number=?");
    $stmt->bind_param("s", $number);
    $stmt->execute(); $stmt->store_result();
    if ($stmt->num_rows > 0) {
        echo json_encode(["status" => "error", "message" => "Number Is Already Registered"], JSON_PRETTY_PRINT);
        exit;
    }
    $stmt->close();

    if ($refer_code === '') {
        $stmt = $conn->prepare("INSERT INTO users (name,email,number,password,fcm_key,device_id,reg_date,refer_code) VALUES (?,?,?,?,?,?,?,?)");

        $stmt->bind_param("ssssssss", $name, $email, $number, $password, $fcm_key, $device_id,$date,$rs_refer);
        if ($stmt->execute()) {
            $ipLog[$ipAddress] = $currentTime;
            file_put_contents($logFile, json_encode($ipLog, JSON_PRETTY_PRINT));
            echo json_encode([
                
                "status"  => "success", 
                "message" => "Registation Successfully",
                "name"    => $name,
                "em"      => $email,
                "number"  => $number,
                "pw"      => $password,
                "did"     => $device_id,
                 
                ], JSON_PRETTY_PRINT);
        } else {
            echo json_encode(["status" => "error", "message" => "Registration failed"], JSON_PRETTY_PRINT);
        }
        $stmt->close();
    } else {
        $stmt = $conn->prepare("SELECT 1 FROM users WHERE refer_code = ?");
        $stmt->bind_param("s", $refer_code);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 0) {
            echo json_encode(["status" => "error", "message" => "Invalid Promo Code"], JSON_PRETTY_PRINT);
            exit;
        }
        $stmt->close();

        $conn->begin_transaction();

        $stmt = $conn->prepare("INSERT INTO users (name,email,number,password,balance,fcm_key,device_id,reg_date,refer_code) VALUES (?,?,?,?,?,?,?,?,?)");
        $balance = 5;
        $stmt->bind_param("ssssissss", $name, $email, $number, $password, $balance, $fcm_key, $device_id,$date,$rs_refer);
        $ok1 = $stmt->execute();
        $stmt->close();

        $stmt = $conn->prepare("UPDATE users SET total_refer=total_refer+1 WHERE refer_code = ?");
        $stmt->bind_param("s", $refer_code);
        $ok2 = $stmt->execute();
        $stmt->close();


        if ($ok1 && $ok2) {
            $conn->commit();
            $ipLog[$ipAddress] = $currentTime;
            file_put_contents($logFile, json_encode($ipLog, JSON_PRETTY_PRINT));
            
            echo json_encode([
                
                "status"  => "success", 
                "message" => "Registation Successfully",
                "name"    => $name,
                "em"      => $email,
                "number"  => $number,
                "pw"      => $password,
                "did"     => $device_id,
                 
                ], JSON_PRETTY_PRINT);
        } else {
            $conn->rollback();
            echo json_encode(["status" => "error", "message" => "Registration failed"], JSON_PRETTY_PRINT);
        }
    }
} else {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);
}

$conn->close();
?>
