<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');

include("../rs.php");

$matchkey   = $_POST['match_key'] ?? '';
$email      = $_POST['email'] ?? '';
$password   = $_POST['password'] ?? '';
$did        = $_POST['did'] ?? '';
$entry_type = $_POST['entry_type'] ?? '';
$name       = $_POST['name'] ?? '';
$name2      = $_POST['name2'] ?? '';
$name3      = $_POST['name3'] ?? '';
$name4      = $_POST['name4'] ?? '';
$time = date("d/m/Y h:i a");

if (empty($matchkey) || empty($email) || empty($password) || empty($did) || empty($entry_type) || empty($name)) {
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

$user_sql = "SELECT balance, total_play FROM users WHERE email = ? AND password = ? AND device_id = ? AND `status` = 'Unban'";
$user_stmt = $conn->prepare($user_sql);
$user_stmt->bind_param("sss", $email, $password, $did);
$user_stmt->execute();
$user_result = $user_stmt->get_result();

if ($user_result->num_rows == 0) {
    http_response_code(403);
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

$user_row = $user_result->fetch_assoc();
$user_balance = (int)$user_row['balance'];
$user_tp      = (int)$user_row['total_play'];

$match_sql = "SELECT title, ef, tj, total_players FROM `match` WHERE matchkey = ?";
$match_stmt = $conn->prepare($match_sql);
$match_stmt->bind_param("s", $matchkey);
$match_stmt->execute();
$match_result = $match_stmt->get_result();

if ($match_result->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

$match_row = $match_result->fetch_assoc();
$entryfees     = (int)$match_row['ef'];
$joined        = (int)$match_row['tj'];
$total_players = (int)$match_row['total_players'];
$title = $match_row['title'];

$players_to_add = [];
if ($entry_type === "Solo") {
    $players_to_add = [$name];
    $required_fee = $entryfees;
} elseif ($entry_type === "Duo") {
    if (empty($name2)) {
        echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        exit();
    }
    $players_to_add = [$name, $name2];
    $required_fee = $entryfees * 2;
} elseif ($entry_type === "Squad") {
    if (empty($name2) || empty($name3) || empty($name4)) {
        echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        exit();
    }
    $players_to_add = [$name, $name2, $name3, $name4];
    $required_fee = $entryfees * 4;
} else {
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}


$check_sql = "SELECT COUNT(*) as cnt FROM participate WHERE matchkey = ? AND email = ? AND password = ?";
$check_stmt = $conn->prepare($check_sql);
$check_stmt->bind_param("sss", $matchkey, $email, $password);
$check_stmt->execute();
$check_result = $check_stmt->get_result();
$check_row = $check_result->fetch_assoc();
$already_joined_count = (int)$check_row['cnt'];

$expected_count = 0;
if ($entry_type === "Solo") {
    $expected_count = 1;
} elseif ($entry_type === "Duo") {
    $expected_count = 2;
} elseif ($entry_type === "Squad") {
    $expected_count = 4;
}

if ($already_joined_count >= $expected_count) {
    echo json_encode(["status" => "error", "message" => "Already Joined"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}


$new_joined = $joined + count($players_to_add);
if ($new_joined > $total_players) {
    echo json_encode(["status" => "error", "message" => "Already Match Full"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

if ($user_balance < $required_fee) {
    echo json_encode(["status" => "error", "message" => "Insufficient Balance"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

$conn->begin_transaction();
try {
    $insert_sql = "INSERT INTO participate (name, matchkey, email, password) VALUES (?, ?, ?, ?)";
    $insert_stmt = $conn->prepare($insert_sql);
    foreach ($players_to_add as $pname) {
        $insert_stmt->bind_param("ssss", $pname, $matchkey, $email, $password);
        $insert_stmt->execute();
    }

    $new_balance = $user_balance - $required_fee;
    $new_tp      = $user_tp + 1;
    $update_user_sql = "UPDATE users SET balance = ?, total_play = ? WHERE email = ?";
    $update_user_stmt = $conn->prepare($update_user_sql);
    $update_user_stmt->bind_param("iis", $new_balance, $new_tp, $email);
    $update_user_stmt->execute();

    $update_match_sql = "UPDATE `match` SET tj = ? WHERE matchkey = ?";
    $update_match_stmt = $conn->prepare($update_match_sql);
    $update_match_stmt->bind_param("is", $new_joined, $matchkey);
    $update_match_stmt->execute();
    
    
$insert_history_sql = "INSERT INTO match_history (title, time, entry_fees, email, password, match_key) VALUES (?, ?, ?, ?, ?, ?)";
$insert_history_stmt = $conn->prepare($insert_history_sql);
$insert_history_stmt->bind_param("ssisss", $title, $time, $required_fee, $email, $password, $matchkey);
$insert_history_stmt->execute();

    $conn->commit();
    echo json_encode(["status" => "success", "message" => "Successfully Joined"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}

$conn->close();
?>