<?php
include ("../rs.php");

header('Content-Type: application/json; charset=UTF-8');

function error_response($msg = "Access Denied") {
    echo json_encode(["status" => "error", "message" => $msg], JSON_PRETTY_PRINT);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    error_response();
}

$email    = isset($_POST['email'])    ? trim($_POST['email'])    : '';
$password = isset($_POST['password']) ? trim($_POST['password']) : '';
$did      = isset($_POST['did'])      ? trim($_POST['did'])      : '';
$type     = isset($_POST['type'])     ? trim($_POST['type'])     : '';
$name     = isset($_POST['name'])     ? trim($_POST['name'])     : '';
$number   = isset($_POST['number'])   ? trim($_POST['number'])   : '';
$oldpass  = isset($_POST['oldpass'])  ? trim($_POST['oldpass'])  : '';
$newpass  = isset($_POST['newpass'])  ? trim($_POST['newpass'])  : '';


if ($email === '' || $password === '' || $did === '' || $type === '') {
    error_response();
}

$stmt = $conn->prepare("SELECT name, total_play, winning, balance, status, email, number, password FROM users WHERE email = ? AND password = ? AND device_id = ?");
$stmt->bind_param("sss", $email, $password, $did);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    error_response();
}

$user = $result->fetch_assoc();
$stmt->close();

if ($type === 'details') {
    echo json_encode([
        "name"   => $user['name'],
        "total_play"  => $user['total_play'],
        "winning" => $user['winning'],
        "balance"  => $user['balance'],
        "status"  => $user['status']
    ], JSON_PRETTY_PRINT);
 
    
} elseif ($type === 'info') {
    echo json_encode([
        "name"   => $user['name'],
        "email"  => $user['email'],
        "number" => $user['number']
    ], JSON_PRETTY_PRINT);

    
} elseif ($type === 'edit') {
    if ($name === '' || $number === '') {
        error_response();
    }

    $stmt = $conn->prepare("UPDATE users SET name = ?, number = ? WHERE email = ?");
    $stmt->bind_param("sss", $name, $number, $email);

    echo $stmt->execute()
        ? json_encode(["status" => "success", "message" => "Profile Update Successfully"], JSON_PRETTY_PRINT)
        : json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);

    $stmt->close();
}

elseif ($type === 'password') {
    if ($oldpass === '' || $newpass === '') {
        error_response();
    }

    if ($oldpass !== $user['password']) {
        error_response("Old Password Is Incorrect!");
    }

    $stmt = $conn->prepare("UPDATE users SET password = ? WHERE email = ?");
    $stmt->bind_param("ss", $newpass, $email);

    echo $stmt->execute()
        ? json_encode(["status" => "success", "message" => "Password Changed Successfully"], JSON_PRETTY_PRINT)
        : json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);

    $stmt->close();
}

else {
    error_response();
}

$conn->close();
?>
