<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');

include("../rs.php");

if (!isset($_POST['status'], $_POST['match_type'], $_POST['email'], $_POST['password'], $_POST['did'], $_POST['page'])) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    if (isset($conn)) { $conn->close(); }
    exit();
}

$page = $_POST['page'];
$limit = 100; 
$offset = ($page - 1) * $limit;
$status     = $_POST['status'];
$match_type = $_POST['match_type'];
$email      = $_POST['email'];
$password   = $_POST['password'];
$did        = $_POST['did'];

$user_check_sql = "SELECT 1 FROM users WHERE email = ? AND password = ? AND device_id = ? AND `status` = 'Unban'";
$user_check_stmt = $conn->prepare($user_check_sql);
$user_check_stmt->bind_param("sss", $email, $password, $did);
$user_check_stmt->execute();
$user_check_result = $user_check_stmt->get_result();

if ($user_check_result->num_rows == 0) {
    $user_check_stmt->close();
    $conn->close();
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}
$user_check_stmt->close();

$data = [];

if ($status == "Match") {


    $join_sql = "SELECT matchkey FROM participate WHERE email = ? AND password = ?";
    $join_stmt = $conn->prepare($join_sql);
    $join_stmt->bind_param("ss", $email, $password);
    $join_stmt->execute();
    $join_result = $join_stmt->get_result();

    $joined_matchkeys = [];
    while ($join_row = $join_result->fetch_assoc()) {
        $joined_matchkeys[] = $join_row['matchkey'];
    }
    $join_stmt->close();


$sql = "SELECT * FROM `match` 
        WHERE `status` = 'Match' AND match_type = ? 
        ORDER BY STR_TO_DATE(CONCAT(`date`, ' ', `time`), '%d/%m/%Y %h:%i %p') ASC
        LIMIT ? OFFSET ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("sii", $match_type, $limit, $offset);
$stmt->execute();
$result = $stmt->get_result();


    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            if (in_array($row['matchkey'], $joined_matchkeys)) {
                $row['join_status'] = "true";
            } else {
                $row['join_status'] = "false";
                $row['roomid'] = "fuck you bbz";
                $row['roompass'] = "this is not possible";
            }
            $data[] = $row;
        }
        $stmt->close();
        $conn->close();
        echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    } else {
        $stmt->close();
        $conn->close();
        echo "empty";
    }

} elseif ($status == "Result") {

   $sql = "SELECT * FROM `match` WHERE `status` = 'Result' AND match_type = ? ORDER BY id DESC LIMIT ? OFFSET ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sii", $match_type, $limit, $offset);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $data = $result->fetch_all(MYSQLI_ASSOC);
        $stmt->close();
        $conn->close();
        echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    } else {
        $stmt->close();
        $conn->close();
        echo "empty";
    }

} else {
    $conn->close();
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
?>
