<?php
header('Content-Type: application/json; charset=utf-8');
include("../rs.php");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    $conn->close();
    exit;
}

$email      = $_POST['email'] ?? '';
$password   = $_POST['password'] ?? '';
$did        = $_POST['did'] ?? '';
$match_key  = $_POST['match_key'] ?? '';

if (empty($email) || empty($password) || empty($did) || empty($match_key)) {
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    $conn->close();
    exit;
}

$user_stmt = $conn->prepare("SELECT 1 FROM users WHERE email=? AND password=? AND device_id=? AND `status`='Unban' LIMIT 1");
$user_stmt->bind_param("sss", $email, $password, $did);
$user_stmt->execute();
$user_result = $user_stmt->get_result();

if ($user_result->num_rows === 0) {
    echo json_encode(["status"=>"error","message"=>"Invalid User"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    $user_stmt->close();
    $conn->close();
    exit;
}
$user_stmt->close();

$join_stmt = $conn->prepare("SELECT 1 FROM participate WHERE email=? AND password=? AND matchkey=? LIMIT 1");
$join_stmt->bind_param("sss", $email, $password, $match_key);
$join_stmt->execute();
$join_result = $join_stmt->get_result();

$joined = ($join_result->num_rows > 0) ? true : false;
$join_stmt->close();

$match_stmt = $conn->prepare("SELECT * FROM `match` WHERE matchkey = ?");
$match_stmt->bind_param("s", $match_key);
$match_stmt->execute();
$match_result = $match_stmt->get_result();

if ($match_result->num_rows === 0) {
    echo json_encode(["status"=>"error","message"=>"Match not found"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    $match_stmt->close();
    $conn->close();
    exit;
}

$match = $match_result->fetch_assoc();
$match_stmt->close();
$conn->close();

if (!$joined) {
    $match['join_status'] = "false";
    $match['roomid'] = "Locked 🔒";
    $match['roompass'] = "Join the match to unlock!";
} else {
    $match['join_status'] = "true";
}

echo json_encode($match, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
exit;
?>