<?php
header('Content-Type: application/json; charset=utf-8');

include("../rs.php");

$matchkey = $_POST['match_key'] ?? '';
$email    = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';
$did      = $_POST['did'] ?? '';

if (empty($matchkey) || empty($email) || empty($password) || empty($did)) {
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}


$userCheckSql = "SELECT id FROM users WHERE email = ? AND password = ? AND device_id = ? AND `status` = 'Unban' LIMIT 1";
$userStmt = $conn->prepare($userCheckSql);
if(!$userStmt){
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}
$userStmt->bind_param("sss", $email, $password, $did);
$userStmt->execute();
$userResult = $userStmt->get_result();
$userStmt->close();

if ($userResult->num_rows === 0) {
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    $conn->close();
    exit();
}


$sql = "SELECT name FROM participate WHERE matchkey = ? ORDER BY CAST(id AS UNSIGNED) ASC";
$stmt = $conn->prepare($sql);
if(!$stmt){
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}
$stmt->bind_param("s", $matchkey);
$stmt->execute();
$result = $stmt->get_result();

$finalResult = [];
while ($row = $result->fetch_assoc()) {
    $finalResult[] = ["name" => $row['name']];
}

$stmt->close();
$conn->close();

if (!empty($finalResult)) {
    echo json_encode($finalResult, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} else {
    echo "empty";
}
?>
