<?php

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');


include("../rs.php");

$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';
$did = $_POST['did'] ?? '';
$action = $_POST['action'] ?? '';


$stmt = $conn->prepare("SELECT 1 FROM users WHERE email = ? AND password = ? AND device_id = ?");
$stmt->bind_param("sss", $email, $password, $did);
$stmt->execute();
$result_user = $stmt->get_result();

if ($result_user->num_rows == 0) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

$response = [];

if ($action === 'count') {
  
    $user_data = $result_user->fetch_assoc();
    $response = $user_data;

    $categories = [
        "BATTLE ROYAL",
        "CLASH SQUAD",
        "LONE WOLF",
        "CSV2",
        "LUDO",
        "FREE MATCH"
    ];

    foreach ($categories as $category) {
        $stmt_match = $conn->prepare("SELECT COUNT(*) as count FROM `match` WHERE `status` = 'Match' AND `match_type` = ?");
        $stmt_match->bind_param("s", $category);
        $stmt_match->execute();
        $result_match = $stmt_match->get_result();
        $row = $result_match->fetch_assoc();

        $response[$category] = strval(intval($row['count']));
    }

} else if ($action === 'slider') {
   
    $result_user->fetch_assoc(); 

    $sql_slider = "SELECT * FROM slider";
    $result_slider = $conn->query($sql_slider);
    if ($result_slider->num_rows > 0) {
        $slider_data = [];
        while ($row = $result_slider->fetch_assoc()) {
            $slider_data[] = $row;
        }
        $response = $slider_data;
    } else {
        $response = "empty";
    }
} else {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

$conn->close();
?>
