<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');
include ("../rs.php");

$page = $_POST['page'];
$limit = 100;
$offset = ($page - 1) * $limit;
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$password = isset($_POST['password']) ? trim($_POST['password']) : '';

if (empty($email) || empty($password) || empty($page)) {
    http_response_code(400);
    echo json_encode(["status" => "error","message" => "Access Denied"], JSON_PRETTY_PRINT);
    exit();
}

$stmt = $conn->prepare("SELECT 1 FROM admins WHERE email = ? AND password = ?");
$stmt->bind_param("ss", $email, $password);
$stmt->execute();
$admin_result = $stmt->get_result();

if ($admin_result->num_rows === 0) {
    http_response_code(403);
    echo json_encode(["status" => "error","message" => "Access Denied"], JSON_PRETTY_PRINT);
    $stmt->close();
    $conn->close();
    exit();
}
$stmt->close();

$stmt = $conn->prepare("SELECT id, name, balance, winning, number, email, password, device_id, fcm_key FROM users LIMIT ? OFFSET ?");
$stmt->bind_param("ii", $limit, $offset);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $users = [];
    while ($row = $result->fetch_assoc()) $users[] = $row;
    echo json_encode($users, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode([], JSON_PRETTY_PRINT);
}

$stmt->close();
$conn->close();
?>