<?php
include ("../rs.php");

header('Content-Type: application/json; charset=UTF-8');

function error_response($msg = "Access Denied") {
    echo json_encode(["status" => "error", "message" => $msg], JSON_PRETTY_PRINT);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    error_response();
}

$email    = isset($_POST['email'])    ? trim($_POST['email'])    : '';
$password = isset($_POST['password']) ? trim($_POST['password']) : '';
$did      = isset($_POST['did'])      ? trim($_POST['did'])      : '';
$admin_email     = isset($_POST['admin_email'])     ? trim($_POST['admin_email'])     : '';
$admin_password     = isset($_POST['admin_password'])     ? trim($_POST['admin_password'])     : '';


if ($email === '' || $password === '' || $did === '' || $admin_email === '' || $admin_password === '') {
    error_response();
}

$stmt = $conn->prepare("SELECT 1 FROM admins WHERE email = ? AND password = ?");
$stmt->bind_param("ss", $admin_email, $admin_password);
$stmt->execute();
$admin_result = $stmt->get_result();

if ($admin_result->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    $stmt->close();
    exit();
}

$stmt = $conn->prepare("SELECT * FROM users WHERE email = ? AND password = ? AND device_id = ?");
$stmt->bind_param("sss", $email, $password, $did);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    error_response();
}

$user = $result->fetch_assoc();
$stmt->close();

    echo json_encode($user, JSON_PRETTY_PRINT);
 
    

$conn->close();
?>
