<?php
header('Content-Type: application/json; charset=UTF-8');
date_default_timezone_set('Asia/Dhaka');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    exit();
}

include("../rs.php");

$required = [
    'admin_email','admin_password',
    'user_email','user_password',
    'visibility','winning','name','kill','id','match_key'
];

foreach ($required as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode([
            "status"  => "error",
            "message" => "Access Denied"
        ], JSON_PRETTY_PRINT);
        exit();
    }
}

$admin_email    = $_POST['admin_email'];
$admin_password = $_POST['admin_password'];
$user_email     = $_POST['user_email'];
$user_password  = $_POST['user_password'];
$name       = $_POST['name'];
$visibility     = $_POST['visibility'];
$winning        = $_POST['winning'];
$kill           = $_POST['kill'];
$id           = $_POST['id'];
$match_key      = $_POST['match_key'];

$admin_sql  = "SELECT 1 FROM admins WHERE email = ? AND password = ?";
$admin_stmt = $conn->prepare($admin_sql);
$admin_stmt->bind_param("ss", $admin_email, $admin_password);
$admin_stmt->execute();
if ($admin_stmt->get_result()->num_rows === 0) {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    exit();
}

$user_sql  = "SELECT `fcm_key` FROM users WHERE email = ? AND password = ?";
$user_stmt = $conn->prepare($user_sql);
$user_stmt->bind_param("ss", $user_email, $user_password);
$user_stmt->execute();
$user_result = $user_stmt->get_result();
if ($user_result->num_rows === 0) {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    exit();
}
$user = $user_result->fetch_assoc();
$fcm_key = $user['fcm_key'];

$match_sql  = "SELECT 1 FROM `match` WHERE matchkey = ?";
$match_stmt = $conn->prepare($match_sql);
$match_stmt->bind_param("s", $match_key);
$match_stmt->execute();
if ($match_stmt->get_result()->num_rows === 0) {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    exit();
}

$part_sql  = "SELECT winning FROM participate WHERE id = ?";
$part_stmt = $conn->prepare($part_sql);
$part_stmt->bind_param("s", $id);
$part_stmt->execute();
$part_result = $part_stmt->get_result();
if ($part_result->num_rows === 0) {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    exit();
}
$part        = $part_result->fetch_assoc();
$current_win = (int)$part['winning'];

if ($current_win != 0) {
    echo json_encode([
        "status"  => "error",
        "message" => "Already Added"
    ], JSON_PRETTY_PRINT);
    exit();
}

if ($visibility === "true") {
$ins_sql  = "INSERT INTO winners (name, `kill`, `winning`, match_key) VALUES (?, ?, ?, ?)";
$ins_stmt = $conn->prepare($ins_sql);
$ins_stmt->bind_param("ssss", $name, $kill, $winning, $match_key);
$ins_stmt->execute();
}

$upd_part_sql  = "UPDATE participate SET `kill` = ?, `winning` = ? WHERE matchkey = ? AND email = ? AND password = ?";
$upd_part_stmt = $conn->prepare($upd_part_sql);
$upd_part_stmt->bind_param("sssss", $kill, $winning, $match_key, $user_email, $user_password);
$upd_part_stmt->execute();

$upd_hist_sql  = "UPDATE match_history SET win = ? WHERE match_key = ? AND email = ? AND password = ?";
$upd_hist_stmt = $conn->prepare($upd_hist_sql);
$upd_hist_stmt->bind_param("ssss", $winning, $match_key, $user_email, $user_password);
$upd_hist_stmt->execute();

$upd_user_sql  = "UPDATE users SET winning = winning + ? WHERE email = ? AND password = ?";
$upd_user_stmt = $conn->prepare($upd_user_sql);
$upd_user_stmt->bind_param("sss", $winning, $user_email, $user_password);
$upd_user_stmt->execute();

echo json_encode([
    "status"  => "success",
    "message" => "Winner Added Successfully",
    "fcm_key" => $fcm_key
], JSON_PRETTY_PRINT);

$conn->close();
?>