<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');
include("../rs.php");

$email    = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';
$battle_royal = $_POST['battle_royal'] ?? '';
$clash_squad  = $_POST['clash_squad'] ?? '';
$lone_wolf    = $_POST['lone_wolf'] ?? '';
$csv2         = $_POST['csv2'] ?? '';
$ludo         = $_POST['ludo'] ?? '';
$free_match   = $_POST['free_match'] ?? '';

if (empty($email) || empty($password)) {
    http_response_code(403);
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

$stmt_admin = $conn->prepare("SELECT 1 FROM `admins` WHERE email = ? AND password = ?");
$stmt_admin->bind_param("ss", $email, $password);
$stmt_admin->execute();
$result_admin = $stmt_admin->get_result();

if ($result_admin->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    $stmt_admin->close();
    $conn->close();
    exit;
}
$stmt_admin->close();

$stmt_update = $conn->prepare("
    UPDATE `rules` 
    SET battle_royal = ?, clash_squad = ?, lone_wolf = ?, csv2 = ?, ludo = ?, free_match = ? 
    LIMIT 1
");
$stmt_update->bind_param("ssssss", $battle_royal, $clash_squad, $lone_wolf, $csv2, $ludo, $free_match);

if ($stmt_update->execute()) {
    echo json_encode([
        "status"  => "success",
        "message" => "Rules Updated"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}

$stmt_update->close();
$conn->close();
?>