<?php

header('Content-Type: application/json; charset=utf-8');
include("../rs.php");

if (!isset($_POST['email'], $_POST['password'], $_POST['matchkey'])) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

$email = $_POST['email'];
$password = $_POST['password'];
$matchkey = $_POST['matchkey'];


$user_check_sql = "SELECT * FROM admins WHERE email = ? AND password = ?";
$user_check_stmt = $conn->prepare($user_check_sql);
$user_check_stmt->bind_param("ss", $email, $password);
$user_check_stmt->execute();
$user_check_result = $user_check_stmt->get_result();

if ($user_check_result->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}


$sql = "SELECT `email`, `password` FROM `match_history` WHERE match_key = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $matchkey);
$stmt->execute();
$result = $stmt->get_result();

$tokens = [];

while ($row = $result->fetch_assoc()) {
    $p_email = $row['email'];
    $p_password = $row['password'];

 
  $user_sql = "SELECT `name`, `fcm_key` FROM users WHERE email = ? AND password = ?";
$user_stmt = $conn->prepare($user_sql);
$user_stmt->bind_param("ss", $p_email, $p_password);
$user_stmt->execute();
$user_result = $user_stmt->get_result();

if ($user_row = $user_result->fetch_assoc()) {
    $tokens[] = [
        "name" => $user_row['name'],
        "fcm_key" => $user_row['fcm_key']
    ];
}

$user_stmt->close();


}

$stmt->close();
$conn->close();


if (count($tokens) > 0) {
    echo json_encode($tokens, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} else {
    echo "empty";
}
?>
