<?php
header('Content-Type: application/json; charset=UTF-8');
error_reporting(0);
date_default_timezone_set('Asia/Dhaka');

include ("../rs.php");

if (!isset($_POST['title'], $_POST['time'], $_POST['date'], $_POST['perkill'], $_POST['ef'], $_POST['tp'], $_POST['total_players'], $_POST['pd'], $_POST['roomid'], $_POST['roompass'], $_POST['email'], $_POST['password'], $_POST['matchkey'])) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

$admin_email = $_POST['email'];
$admin_pass  = $_POST['password'];
$matchkey    = $_POST['matchkey'];

$stmt = $conn->prepare("SELECT 1 FROM admins WHERE email = ? AND password = ?");
$stmt->bind_param("ss", $admin_email, $admin_pass);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);
    $stmt->close();
    $conn->close();
    exit();
}
$stmt->close();

$stmt = $conn->prepare("SELECT 1 FROM `match` WHERE matchkey = ?");
$stmt->bind_param("s", $matchkey);
$stmt->execute();
$res = $stmt->get_result();
if ($res->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "Invalid Match"], JSON_PRETTY_PRINT);
    $stmt->close();
    $conn->close();
    exit();
}
$stmt->close();

$title         = $_POST['title'];
$time          = $_POST['time'];
$date          = $_POST['date'];
$perkill       = $_POST['perkill'];
$ef            = $_POST['ef'];
$tp            = $_POST['tp'];
$total_players = $_POST['total_players'];
$pd            = $_POST['pd'];
$roomid        = $_POST['roomid'];
$roompass      = $_POST['roompass'];

$stmt = $conn->prepare("UPDATE `match` SET title = ?, time = ?, date = ?, perkill = ?, ef = ?, tp = ?, total_players = ?, pd = ?, roomid = ?, roompass = ? WHERE matchkey = ?");
$stmt->bind_param("sssssssssss", $title, $time, $date, $perkill, $ef, $tp, $total_players, $pd, $roomid, $roompass, $matchkey);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Match Updated"], JSON_PRETTY_PRINT);
} else {
    echo json_encode(["status" => "error", "message" => "Update Failed"], JSON_PRETTY_PRINT);
}

$stmt->close();
$conn->close();
?>