<?php
header('Content-Type: application/json; charset=utf-8');
include("../rs.php");

if (!isset($_POST['email'], $_POST['password'], $_POST['matchkey'])) {
    echo json_encode(["status" => "error", "message" => "Access Denied"]);
    exit();
}

$email = $_POST['email'];
$password = $_POST['password'];
$matchkey = $_POST['matchkey'];

$userCheckSql = "SELECT 1 FROM admins WHERE email = ? AND password = ?";
$userStmt = $conn->prepare($userCheckSql);
$userStmt->bind_param("ss", $email, $password);
$userStmt->execute();
$userResult = $userStmt->get_result();

if ($userResult->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "Access Denied"]);
    exit();
}
$userStmt->close();

$sql = "SELECT id, name, email, password FROM participate WHERE matchkey = ? ORDER BY CAST(id AS UNSIGNED) ASC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $matchkey);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

if (!empty($data)) {
    echo json_encode($data);
} else {
    echo "empty";
}

$stmt->close();
$conn->close();
?>