<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');

include("../rs.php");

if (!isset($_POST['status'], $_POST['match_type'], $_POST['email'], $_POST['password'])) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    if (isset($conn)) { $conn->close(); }
    exit();
}

$status     = $_POST['status'];
$match_type = $_POST['match_type'];
$email      = $_POST['email'];
$password   = $_POST['password'];

$user_check_sql = "SELECT 1 FROM admins WHERE email = ? AND password = ?";
$user_check_stmt = $conn->prepare($user_check_sql);
$user_check_stmt->bind_param("ss", $email, $password);
$user_check_stmt->execute();
$user_check_result = $user_check_stmt->get_result();

if ($user_check_result->num_rows == 0) {
    $user_check_stmt->close();
    $conn->close();
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}
$user_check_stmt->close();

$data = [];

if ($status == "Match") {



$sql = "SELECT * FROM `match` 
        WHERE `status` = 'Match' AND match_type = ? 
        ORDER BY STR_TO_DATE(CONCAT(`date`, ' ', `time`), '%d/%m/%Y %h:%i %p') ASC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $match_type);
$stmt->execute();
$result = $stmt->get_result();


    if ($result && $result->num_rows > 0) {
        $data = $result->fetch_all(MYSQLI_ASSOC);
        $stmt->close();
        $conn->close();
        echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    } else {
        $stmt->close();
        $conn->close();
        echo "empty";
    }

} elseif ($status == "Result") {

   $sql = "SELECT * FROM `match` WHERE `status` = 'Result' AND match_type = ? ORDER BY id DESC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $match_type);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $data = $result->fetch_all(MYSQLI_ASSOC);
        $stmt->close();
        $conn->close();
        echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    } else {
        $stmt->close();
        $conn->close();
        echo "empty";
    }

} else {
    $conn->close();
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
?>
